rm(list = ls())
source("_funciones.txt")

############################################################################################################

T1 = 25
T2 = 25

consumo = round(c(rnorm(T1, 2200, sqrt(20)), rnorm(T2, 1800, sqrt(20))), digits = 0) # mensual, euros
salario = round(c(rnorm(T1, 3000, sqrt(20)), rnorm(T2, 2200, sqrt(20))), digits = 0) # mensual, euros
genero = c(array(1, T1), array(0, T2)) # 1 hombre, 2 mujer

# 

# cor(consumo, salario, genero) # ojo, genero es binaria, no tiene sentido
# det(cor(consumo, salario, genero))

x = cbind(salario, genero)
FIV(x)

NC(x)
X = cbind(array(1,length(consumo)),x)
NC(X)

#

reg = lm(consumo~salario+genero)
summary(reg)
beta = reg$coefficients

############################################################################################################

tol = 0.01
media = 5
dv = 5

salario.p = perturb(salario, media, dv, tol)
mean(salario-salario.p)

# 

x.p = cbind(salario.p, genero)
FIV(x.p)

NC(x.p)
X.p = cbind(array(1,length(consumo)),x.p)
NC(X.p)

#

reg.p = lm(consumo~salario.p+genero)
summary(reg.p)
beta.p = reg.p$coefficients

#

(norm(salario-salario.p,"2")/norm(salario,"2"))*100
(norm(beta-beta.p,"2")/norm(beta,"2"))*100

############################################################################################################

datos = cbind(consumo, salario, genero, salario.p)
write(t(datos), "conclusiones.txt", ncolumns = 4, sep=";")

###

datos.p = read.table("conclusiones.txt", sep=";")
head(datos.p)
c = datos.p[,1]
s = datos.p[,2]
g = datos.p[,3]

s.p = datos.p[,4]
g.p = g
ale1 = sample(1:25,1)
ale2 = sample(1:25,1)
g.p[ale1] = 0
g.p[ale2] = 0 
ale3 = sample(26:50,1)
ale4 = sample(26:50,1)
g.p[ale3] = 1
g.p[ale4] = 1
g.p
s.p[ale1] = rnorm(1, 2200, sqrt(20)) # modifico el salario en funcin del gnero
s.p[ale2] = rnorm(1, 2200, sqrt(20))
s.p[ale3] = rnorm(1, 3000, sqrt(20))
s.p[ale4] = rnorm(1, 3000, sqrt(20))

reg = lm(c~s+g)
summary(reg)
beta = reg$coefficients

reg.p = lm(c~s.p+g.p)
summary(reg.p)
beta.p = reg.p$coefficients

(norm(s-s.p,"2")/norm(s,"2"))*100
(norm(beta-beta.p,"2")/norm(beta,"2"))*100

############################################################################################################

cv = function(x){
  cv = sd(x)/mean(x)
  return(cv)
}

# 
sexo = factor(g)
tapply(c, sexo, mean)
tapply(s, sexo, mean)

cv(s)
tapply(s, sexo, cv)

#

s.sol = s - mean(s)
mean(s.sol)

x.sol = cbind(s.sol, g)
FIV(x.sol)

NC(x.sol)
X.sol = cbind(array(1,length(c)),x.sol)
NC(X.sol)

reg.sol = lm(c~s.sol+g)
summary(reg.sol)
beta.sol = reg.sol$coefficients

(norm(beta-beta.sol,"2")/norm(beta,"2"))*100
